package zio.aws.codegurureviewer.model
import zio.aws.codegurureviewer.model.primitives.{
  Owner,
  StateReason,
  Arn,
  PullRequestId,
  TimeStamp,
  Name,
  AssociationArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CodeReview(
    name: Optional[Name] = Optional.Absent,
    codeReviewArn: Optional[Arn] = Optional.Absent,
    repositoryName: Optional[Name] = Optional.Absent,
    owner: Optional[Owner] = Optional.Absent,
    providerType: Optional[zio.aws.codegurureviewer.model.ProviderType] =
      Optional.Absent,
    state: Optional[zio.aws.codegurureviewer.model.JobState] = Optional.Absent,
    stateReason: Optional[StateReason] = Optional.Absent,
    createdTimeStamp: Optional[TimeStamp] = Optional.Absent,
    lastUpdatedTimeStamp: Optional[TimeStamp] = Optional.Absent,
    `type`: Optional[zio.aws.codegurureviewer.model.Type] = Optional.Absent,
    pullRequestId: Optional[PullRequestId] = Optional.Absent,
    sourceCodeType: Optional[zio.aws.codegurureviewer.model.SourceCodeType] =
      Optional.Absent,
    associationArn: Optional[AssociationArn] = Optional.Absent,
    metrics: Optional[zio.aws.codegurureviewer.model.Metrics] = Optional.Absent,
    analysisTypes: Optional[
      Iterable[zio.aws.codegurureviewer.model.AnalysisType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.CodeReview = {
    import CodeReview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.CodeReview
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        codeReviewArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.codeReviewArn)
      .optionallyWith(
        repositoryName.map(value => Name.unwrap(value): java.lang.String)
      )(_.repositoryName)
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(
        createdTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(sourceCodeType.map(value => value.buildAwsValue()))(
        _.sourceCodeType
      )
      .optionallyWith(
        associationArn.map(value =>
          AssociationArn.unwrap(value): java.lang.String
        )
      )(_.associationArn)
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .optionallyWith(
        analysisTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.analysisTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.CodeReview.ReadOnly =
    zio.aws.codegurureviewer.model.CodeReview.wrap(buildAwsValue())
}
object CodeReview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.CodeReview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.CodeReview =
      zio.aws.codegurureviewer.model.CodeReview(
        name.map(value => value),
        codeReviewArn.map(value => value),
        repositoryName.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        createdTimeStamp.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        `type`.map(value => value),
        pullRequestId.map(value => value),
        sourceCodeType.map(value => value.asEditable),
        associationArn.map(value => value),
        metrics.map(value => value.asEditable),
        analysisTypes.map(value => value)
      )
    def name: Optional[Name]
    def codeReviewArn: Optional[Arn]
    def repositoryName: Optional[Name]
    def owner: Optional[Owner]
    def providerType: Optional[zio.aws.codegurureviewer.model.ProviderType]
    def state: Optional[zio.aws.codegurureviewer.model.JobState]
    def stateReason: Optional[StateReason]
    def createdTimeStamp: Optional[TimeStamp]
    def lastUpdatedTimeStamp: Optional[TimeStamp]
    def `type`: Optional[zio.aws.codegurureviewer.model.Type]
    def pullRequestId: Optional[PullRequestId]
    def sourceCodeType
        : Optional[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly]
    def associationArn: Optional[AssociationArn]
    def metrics: Optional[zio.aws.codegurureviewer.model.Metrics.ReadOnly]
    def analysisTypes
        : Optional[List[zio.aws.codegurureviewer.model.AnalysisType]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCodeReviewArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("codeReviewArn", codeReviewArn)
    def getRepositoryName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[Any, AwsError, zio.aws.codegurureviewer.model.JobState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getCreatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getType: ZIO[Any, AwsError, zio.aws.codegurureviewer.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getSourceCodeType: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly
    ] = AwsError.unwrapOptionField("sourceCodeType", sourceCodeType)
    def getAssociationArn: ZIO[Any, AwsError, AssociationArn] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getMetrics
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.Metrics.ReadOnly] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getAnalysisTypes: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.AnalysisType
    ]] = AwsError.unwrapOptionField("analysisTypes", analysisTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReview
  ) extends zio.aws.codegurureviewer.model.CodeReview.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val codeReviewArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.codeReviewArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val repositoryName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryName())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Optional[Owner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Optional[zio.aws.codegurureviewer.model.ProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerType())
        .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state: Optional[zio.aws.codegurureviewer.model.JobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.codegurureviewer.model.JobState.wrap(value))
    override val stateReason: Optional[StateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.StateReason(value)
      )
    override val createdTimeStamp: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val lastUpdatedTimeStamp: Optional[TimeStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimeStamp())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.TimeStamp(value)
        )
    override val `type`: Optional[zio.aws.codegurureviewer.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codegurureviewer.model.Type.wrap(value))
    override val pullRequestId: Optional[PullRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.PullRequestId(value)
      )
    override val sourceCodeType
        : Optional[zio.aws.codegurureviewer.model.SourceCodeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceCodeType())
        .map(value => zio.aws.codegurureviewer.model.SourceCodeType.wrap(value))
    override val associationArn: Optional[AssociationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationArn())
        .map(value =>
          zio.aws.codegurureviewer.model.primitives.AssociationArn(value)
        )
    override val metrics
        : Optional[zio.aws.codegurureviewer.model.Metrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.codegurureviewer.model.Metrics.wrap(value))
    override val analysisTypes
        : Optional[List[zio.aws.codegurureviewer.model.AnalysisType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurureviewer.model.AnalysisType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.CodeReview
  ): zio.aws.codegurureviewer.model.CodeReview.ReadOnly = new Wrapper(impl)
}
