package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeCodeReviewRequest(codeReviewArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest = {
    import DescribeCodeReviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest
      .builder()
      .codeReviewArn(Arn.unwrap(codeReviewArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DescribeCodeReviewRequest.ReadOnly =
    zio.aws.codegurureviewer.model.DescribeCodeReviewRequest
      .wrap(buildAwsValue())
}
object DescribeCodeReviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.DescribeCodeReviewRequest =
      zio.aws.codegurureviewer.model.DescribeCodeReviewRequest(codeReviewArn)
    def codeReviewArn: Arn
    def getCodeReviewArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(codeReviewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest
  ) extends zio.aws.codegurureviewer.model.DescribeCodeReviewRequest.ReadOnly {
    override val codeReviewArn: Arn =
      zio.aws.codegurureviewer.model.primitives.Arn(impl.codeReviewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest
  ): zio.aws.codegurureviewer.model.DescribeCodeReviewRequest.ReadOnly =
    new Wrapper(impl)
}
