package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListCodeReviewsResponse(
    codeReviewSummaries: Option[
      Iterable[zio.aws.codegurureviewer.model.CodeReviewSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse = {
    import ListCodeReviewsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse
      .builder()
      .optionallyWith(
        codeReviewSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeReviewSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListCodeReviewsResponse.ReadOnly =
    zio.aws.codegurureviewer.model.ListCodeReviewsResponse.wrap(buildAwsValue())
}
object ListCodeReviewsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.ListCodeReviewsResponse =
      zio.aws.codegurureviewer.model.ListCodeReviewsResponse(
        codeReviewSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def codeReviewSummaries: Option[
      List[zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getCodeReviewSummaries: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("codeReviewSummaries", codeReviewSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse
  ) extends zio.aws.codegurureviewer.model.ListCodeReviewsResponse.ReadOnly {
    override val codeReviewSummaries: Option[
      List[zio.aws.codegurureviewer.model.CodeReviewSummary.ReadOnly]
    ] = scala
      .Option(impl.codeReviewSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.CodeReviewSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse
  ): zio.aws.codegurureviewer.model.ListCodeReviewsResponse.ReadOnly =
    new Wrapper(impl)
}
