package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codegurureviewer.model.primitives.{
  AssociationId,
  Owner,
  StateReason,
  Arn,
  ConnectionArn,
  TimeStamp,
  Name
}
import scala.jdk.CollectionConverters._
final case class RepositoryAssociation(
    associationId: Option[AssociationId] = None,
    associationArn: Option[Arn] = None,
    connectionArn: Option[ConnectionArn] = None,
    name: Option[Name] = None,
    owner: Option[Owner] = None,
    providerType: Option[zio.aws.codegurureviewer.model.ProviderType] = None,
    state: Option[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      None,
    stateReason: Option[StateReason] = None,
    lastUpdatedTimeStamp: Option[TimeStamp] = None,
    createdTimeStamp: Option[TimeStamp] = None,
    kmsKeyDetails: Option[zio.aws.codegurureviewer.model.KMSKeyDetails] = None,
    s3RepositoryDetails: Option[
      zio.aws.codegurureviewer.model.S3RepositoryDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation = {
    import RepositoryAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.associationArn)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(providerType.map(value => value.unwrap))(_.providerType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(
        lastUpdatedTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTimeStamp)
      .optionallyWith(
        createdTimeStamp.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(kmsKeyDetails.map(value => value.buildAwsValue()))(
        _.kmsKeyDetails
      )
      .optionallyWith(s3RepositoryDetails.map(value => value.buildAwsValue()))(
        _.s3RepositoryDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly =
    zio.aws.codegurureviewer.model.RepositoryAssociation.wrap(buildAwsValue())
}
object RepositoryAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.RepositoryAssociation =
      zio.aws.codegurureviewer.model.RepositoryAssociation(
        associationId.map(value => value),
        associationArn.map(value => value),
        connectionArn.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        providerType.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        lastUpdatedTimeStamp.map(value => value),
        createdTimeStamp.map(value => value),
        kmsKeyDetails.map(value => value.asEditable),
        s3RepositoryDetails.map(value => value.asEditable)
      )
    def associationId: Option[AssociationId]
    def associationArn: Option[Arn]
    def connectionArn: Option[ConnectionArn]
    def name: Option[Name]
    def owner: Option[Owner]
    def providerType: Option[zio.aws.codegurureviewer.model.ProviderType]
    def state: Option[zio.aws.codegurureviewer.model.RepositoryAssociationState]
    def stateReason: Option[StateReason]
    def lastUpdatedTimeStamp: Option[TimeStamp]
    def createdTimeStamp: Option[TimeStamp]
    def kmsKeyDetails
        : Option[zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly]
    def s3RepositoryDetails
        : Option[zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getProviderType
        : ZIO[Any, AwsError, zio.aws.codegurureviewer.model.ProviderType] =
      AwsError.unwrapOptionField("providerType", providerType)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociationState
    ] = AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getLastUpdatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTimeStamp", lastUpdatedTimeStamp)
    def getCreatedTimeStamp: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getKmsKeyDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("kmsKeyDetails", kmsKeyDetails)
    def getS3RepositoryDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly
    ] = AwsError.unwrapOptionField("s3RepositoryDetails", s3RepositoryDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
  ) extends zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.AssociationId(value)
      )
    override val associationArn: Option[Arn] = scala
      .Option(impl.associationArn())
      .map(value => zio.aws.codegurureviewer.model.primitives.Arn(value))
    override val connectionArn: Option[ConnectionArn] = scala
      .Option(impl.connectionArn())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.ConnectionArn(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.codegurureviewer.model.primitives.Name(value))
    override val owner: Option[Owner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.codegurureviewer.model.primitives.Owner(value))
    override val providerType
        : Option[zio.aws.codegurureviewer.model.ProviderType] = scala
      .Option(impl.providerType())
      .map(value => zio.aws.codegurureviewer.model.ProviderType.wrap(value))
    override val state
        : Option[zio.aws.codegurureviewer.model.RepositoryAssociationState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.codegurureviewer.model.RepositoryAssociationState.wrap(value)
        )
    override val stateReason: Option[StateReason] = scala
      .Option(impl.stateReason())
      .map(value =>
        zio.aws.codegurureviewer.model.primitives.StateReason(value)
      )
    override val lastUpdatedTimeStamp: Option[TimeStamp] = scala
      .Option(impl.lastUpdatedTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val createdTimeStamp: Option[TimeStamp] = scala
      .Option(impl.createdTimeStamp())
      .map(value => zio.aws.codegurureviewer.model.primitives.TimeStamp(value))
    override val kmsKeyDetails
        : Option[zio.aws.codegurureviewer.model.KMSKeyDetails.ReadOnly] = scala
      .Option(impl.kmsKeyDetails())
      .map(value => zio.aws.codegurureviewer.model.KMSKeyDetails.wrap(value))
    override val s3RepositoryDetails
        : Option[zio.aws.codegurureviewer.model.S3RepositoryDetails.ReadOnly] =
      scala
        .Option(impl.s3RepositoryDetails())
        .map(value =>
          zio.aws.codegurureviewer.model.S3RepositoryDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation
  ): zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly =
    new Wrapper(impl)
}
