package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCodeReviewResponse(
    codeReview: Option[zio.aws.codegurureviewer.model.CodeReview] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse = {
    import DescribeCodeReviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse
      .builder()
      .optionallyWith(codeReview.map(value => value.buildAwsValue()))(
        _.codeReview
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly =
    zio.aws.codegurureviewer.model.DescribeCodeReviewResponse
      .wrap(buildAwsValue())
}
object DescribeCodeReviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.DescribeCodeReviewResponse =
      zio.aws.codegurureviewer.model
        .DescribeCodeReviewResponse(codeReview.map(value => value.asEditable))
    def codeReview: Option[zio.aws.codegurureviewer.model.CodeReview.ReadOnly]
    def getCodeReview: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeReview.ReadOnly
    ] = AwsError.unwrapOptionField("codeReview", codeReview)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse
  ) extends zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly {
    override val codeReview
        : Option[zio.aws.codegurureviewer.model.CodeReview.ReadOnly] = scala
      .Option(impl.codeReview())
      .map(value => zio.aws.codegurureviewer.model.CodeReview.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse
  ): zio.aws.codegurureviewer.model.DescribeCodeReviewResponse.ReadOnly =
    new Wrapper(impl)
}
