package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Repository(
    codeCommit: Option[zio.aws.codegurureviewer.model.CodeCommitRepository] =
      None,
    bitbucket: Option[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository
    ] = None,
    gitHubEnterpriseServer: Option[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository
    ] = None,
    s3Bucket: Option[zio.aws.codegurureviewer.model.S3Repository] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.Repository = {
    import Repository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.Repository
      .builder()
      .optionallyWith(codeCommit.map(value => value.buildAwsValue()))(
        _.codeCommit
      )
      .optionallyWith(bitbucket.map(value => value.buildAwsValue()))(
        _.bitbucket
      )
      .optionallyWith(
        gitHubEnterpriseServer.map(value => value.buildAwsValue())
      )(_.gitHubEnterpriseServer)
      .optionallyWith(s3Bucket.map(value => value.buildAwsValue()))(_.s3Bucket)
      .build()
  }
  def asReadOnly: zio.aws.codegurureviewer.model.Repository.ReadOnly =
    zio.aws.codegurureviewer.model.Repository.wrap(buildAwsValue())
}
object Repository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.Repository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.Repository =
      zio.aws.codegurureviewer.model.Repository(
        codeCommit.map(value => value.asEditable),
        bitbucket.map(value => value.asEditable),
        gitHubEnterpriseServer.map(value => value.asEditable),
        s3Bucket.map(value => value.asEditable)
      )
    def codeCommit
        : Option[zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly]
    def bitbucket: Option[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ]
    def gitHubEnterpriseServer: Option[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ]
    def s3Bucket: Option[zio.aws.codegurureviewer.model.S3Repository.ReadOnly]
    def getCodeCommit: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly
    ] = AwsError.unwrapOptionField("codeCommit", codeCommit)
    def getBitbucket: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = AwsError.unwrapOptionField("bitbucket", bitbucket)
    def getGitHubEnterpriseServer: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gitHubEnterpriseServer",
      gitHubEnterpriseServer
    )
    def getS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.S3Repository.ReadOnly
    ] = AwsError.unwrapOptionField("s3Bucket", s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.Repository
  ) extends zio.aws.codegurureviewer.model.Repository.ReadOnly {
    override val codeCommit
        : Option[zio.aws.codegurureviewer.model.CodeCommitRepository.ReadOnly] =
      scala
        .Option(impl.codeCommit())
        .map(value =>
          zio.aws.codegurureviewer.model.CodeCommitRepository.wrap(value)
        )
    override val bitbucket: Option[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = scala
      .Option(impl.bitbucket())
      .map(value =>
        zio.aws.codegurureviewer.model.ThirdPartySourceRepository.wrap(value)
      )
    override val gitHubEnterpriseServer: Option[
      zio.aws.codegurureviewer.model.ThirdPartySourceRepository.ReadOnly
    ] = scala
      .Option(impl.gitHubEnterpriseServer())
      .map(value =>
        zio.aws.codegurureviewer.model.ThirdPartySourceRepository.wrap(value)
      )
    override val s3Bucket
        : Option[zio.aws.codegurureviewer.model.S3Repository.ReadOnly] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.codegurureviewer.model.S3Repository.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.Repository
  ): zio.aws.codegurureviewer.model.Repository.ReadOnly = new Wrapper(impl)
}
