package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codegurureviewer.model.primitives.BranchName
import scala.jdk.CollectionConverters._
final case class BranchDiffSourceCodeType(
    sourceBranchName: BranchName,
    destinationBranchName: BranchName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.BranchDiffSourceCodeType = {
    import BranchDiffSourceCodeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.BranchDiffSourceCodeType
      .builder()
      .sourceBranchName(BranchName.unwrap(sourceBranchName): java.lang.String)
      .destinationBranchName(
        BranchName.unwrap(destinationBranchName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly =
    zio.aws.codegurureviewer.model.BranchDiffSourceCodeType
      .wrap(buildAwsValue())
}
object BranchDiffSourceCodeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.BranchDiffSourceCodeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurureviewer.model.BranchDiffSourceCodeType =
      zio.aws.codegurureviewer.model
        .BranchDiffSourceCodeType(sourceBranchName, destinationBranchName)
    def sourceBranchName: BranchName
    def destinationBranchName: BranchName
    def getSourceBranchName: ZIO[Any, Nothing, BranchName] =
      ZIO.succeed(sourceBranchName)
    def getDestinationBranchName: ZIO[Any, Nothing, BranchName] =
      ZIO.succeed(destinationBranchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.BranchDiffSourceCodeType
  ) extends zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly {
    override val sourceBranchName: BranchName =
      zio.aws.codegurureviewer.model.primitives
        .BranchName(impl.sourceBranchName())
    override val destinationBranchName: BranchName =
      zio.aws.codegurureviewer.model.primitives
        .BranchName(impl.destinationBranchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.BranchDiffSourceCodeType
  ): zio.aws.codegurureviewer.model.BranchDiffSourceCodeType.ReadOnly =
    new Wrapper(impl)
}
