package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRepositoryAssociationsResponse(
    repositoryAssociationSummaries: Option[
      Iterable[zio.aws.codegurureviewer.model.RepositoryAssociationSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse = {
    import ListRepositoryAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse
      .builder()
      .optionallyWith(
        repositoryAssociationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositoryAssociationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly =
    zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse
      .wrap(buildAwsValue())
}
object ListRepositoryAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse =
      zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse(
        repositoryAssociationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def repositoryAssociationSummaries: Option[
      List[zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getRepositoryAssociationSummaries: ZIO[Any, AwsError, List[
      zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "repositoryAssociationSummaries",
      repositoryAssociationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse
  ) extends zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly {
    override val repositoryAssociationSummaries: Option[
      List[zio.aws.codegurureviewer.model.RepositoryAssociationSummary.ReadOnly]
    ] = scala
      .Option(impl.repositoryAssociationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurureviewer.model.RepositoryAssociationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codegurureviewer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse
  ): zio.aws.codegurureviewer.model.ListRepositoryAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
