package zio.aws.codegurureviewer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codegurureviewer.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class DisassociateRepositoryResponse(
    repositoryAssociation: Option[
      zio.aws.codegurureviewer.model.RepositoryAssociation
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryResponse = {
    import DisassociateRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryResponse
      .builder()
      .optionallyWith(
        repositoryAssociation.map(value => value.buildAwsValue())
      )(_.repositoryAssociation)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly =
    zio.aws.codegurureviewer.model.DisassociateRepositoryResponse
      .wrap(buildAwsValue())
}
object DisassociateRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codegurureviewer.model.DisassociateRepositoryResponse =
      zio.aws.codegurureviewer.model.DisassociateRepositoryResponse(
        repositoryAssociation.map(value => value.asEditable),
        tags.map(value => value)
      )
    def repositoryAssociation
        : Option[zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getRepositoryAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryAssociation", repositoryAssociation)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryResponse
  ) extends zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly {
    override val repositoryAssociation: Option[
      zio.aws.codegurureviewer.model.RepositoryAssociation.ReadOnly
    ] = scala
      .Option(impl.repositoryAssociation())
      .map(value =>
        zio.aws.codegurureviewer.model.RepositoryAssociation.wrap(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codegurureviewer.model.primitives.TagKey(
              key
            ) -> zio.aws.codegurureviewer.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryResponse
  ): zio.aws.codegurureviewer.model.DisassociateRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
