package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters.*
sealed trait AgentParameterField {
  def unwrap: software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField
}
object AgentParameterField {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField
  ): zio.aws.codeguruprofiler.model.AgentParameterField = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.SAMPLING_INTERVAL_IN_MILLISECONDS =>
      val r = SamplingIntervalInMilliseconds
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.REPORTING_INTERVAL_IN_MILLISECONDS =>
      val r = ReportingIntervalInMilliseconds
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.MINIMUM_TIME_FOR_REPORTING_IN_MILLISECONDS =>
      val r = MinimumTimeForReportingInMilliseconds
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.MEMORY_USAGE_LIMIT_PERCENT =>
      val r = MemoryUsageLimitPercent
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.MAX_STACK_DEPTH =>
      val r = MaxStackDepth
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.AgentParameterField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField =
      software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.UNKNOWN_TO_SDK_VERSION
  }
  case object SamplingIntervalInMilliseconds
      extends zio.aws.codeguruprofiler.model.AgentParameterField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField =
      software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.SAMPLING_INTERVAL_IN_MILLISECONDS
  }
  case object ReportingIntervalInMilliseconds
      extends zio.aws.codeguruprofiler.model.AgentParameterField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField =
      software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.REPORTING_INTERVAL_IN_MILLISECONDS
  }
  case object MinimumTimeForReportingInMilliseconds
      extends zio.aws.codeguruprofiler.model.AgentParameterField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField =
      software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.MINIMUM_TIME_FOR_REPORTING_IN_MILLISECONDS
  }
  case object MemoryUsageLimitPercent
      extends zio.aws.codeguruprofiler.model.AgentParameterField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField =
      software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.MEMORY_USAGE_LIMIT_PERCENT
  }
  case object MaxStackDepth
      extends zio.aws.codeguruprofiler.model.AgentParameterField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField =
      software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField.MAX_STACK_DEPTH
  }
}
