package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters.*
sealed trait OrderBy {
  def unwrap: software.amazon.awssdk.services.codeguruprofiler.model.OrderBy
}
object OrderBy {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.OrderBy
  ): zio.aws.codeguruprofiler.model.OrderBy = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.OrderBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.OrderBy.TIMESTAMP_DESCENDING =>
      val r = TimestampDescending
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.OrderBy.TIMESTAMP_ASCENDING =>
      val r = TimestampAscending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.OrderBy {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.OrderBy =
      software.amazon.awssdk.services.codeguruprofiler.model.OrderBy.UNKNOWN_TO_SDK_VERSION
  }
  case object TimestampDescending
      extends zio.aws.codeguruprofiler.model.OrderBy {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.OrderBy =
      software.amazon.awssdk.services.codeguruprofiler.model.OrderBy.TIMESTAMP_DESCENDING
  }
  case object TimestampAscending
      extends zio.aws.codeguruprofiler.model.OrderBy {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.OrderBy =
      software.amazon.awssdk.services.codeguruprofiler.model.OrderBy.TIMESTAMP_ASCENDING
  }
}
