package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.Percentage
import scala.jdk.CollectionConverters.*
final case class Pattern(
    countersToAggregate: Optional[Iterable[String]] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    resolutionSteps: Optional[String] = Optional.Absent,
    targetFrames: Optional[Iterable[Iterable[String]]] = Optional.Absent,
    thresholdPercent: Optional[Percentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.Pattern = {
    import Pattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.Pattern
      .builder()
      .optionallyWith(
        countersToAggregate.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.countersToAggregate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resolutionSteps.map(value => value: java.lang.String))(
        _.resolutionSteps
      )
      .optionallyWith(
        targetFrames.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.targetFrames)
      .optionallyWith(
        thresholdPercent.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.thresholdPercent)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.Pattern.ReadOnly =
    zio.aws.codeguruprofiler.model.Pattern.wrap(buildAwsValue())
}
object Pattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.Pattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.Pattern =
      zio.aws.codeguruprofiler.model.Pattern(
        countersToAggregate.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value),
        resolutionSteps.map(value => value),
        targetFrames.map(value => value),
        thresholdPercent.map(value => value)
      )
    def countersToAggregate: Optional[List[String]]
    def description: Optional[String]
    def id: Optional[String]
    def name: Optional[String]
    def resolutionSteps: Optional[String]
    def targetFrames: Optional[List[List[String]]]
    def thresholdPercent: Optional[Percentage]
    def getCountersToAggregate: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("countersToAggregate", countersToAggregate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getResolutionSteps: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolutionSteps", resolutionSteps)
    def getTargetFrames: ZIO[Any, AwsError, List[List[String]]] =
      AwsError.unwrapOptionField("targetFrames", targetFrames)
    def getThresholdPercent: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("thresholdPercent", thresholdPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Pattern
  ) extends zio.aws.codeguruprofiler.model.Pattern.ReadOnly {
    override val countersToAggregate: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countersToAggregate())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val resolutionSteps: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resolutionSteps())
      .map(value => value: String)
    override val targetFrames: Optional[List[List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetFrames())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item: String
            }.toList
          }.toList
        )
    override val thresholdPercent: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.thresholdPercent())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Pattern
  ): zio.aws.codeguruprofiler.model.Pattern.ReadOnly = new Wrapper(impl)
}
