package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListFindingsReportsResponse(
    findingsReportSummaries: Iterable[
      zio.aws.codeguruprofiler.model.FindingsReportSummary
    ],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse = {
    import ListFindingsReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse
      .builder()
      .findingsReportSummaries(findingsReportSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.ListFindingsReportsResponse
      .wrap(buildAwsValue())
}
object ListFindingsReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListFindingsReportsResponse =
      zio.aws.codeguruprofiler.model.ListFindingsReportsResponse(
        findingsReportSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def findingsReportSummaries
        : List[zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getFindingsReportSummaries: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly
    ]] = ZIO.succeed(findingsReportSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse
  ) extends zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly {
    override val findingsReportSummaries
        : List[zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly] =
      impl
        .findingsReportSummaries()
        .asScala
        .map { item =>
          zio.aws.codeguruprofiler.model.FindingsReportSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse
  ): zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly =
    new Wrapper(impl)
}
