package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AgentOrchestrationConfig(profilingEnabled: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.AgentOrchestrationConfig = {
    import AgentOrchestrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.AgentOrchestrationConfig
      .builder()
      .profilingEnabled(profilingEnabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly =
    zio.aws.codeguruprofiler.model.AgentOrchestrationConfig
      .wrap(buildAwsValue())
}
object AgentOrchestrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.AgentOrchestrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.AgentOrchestrationConfig =
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig(profilingEnabled)
    def profilingEnabled: Boolean
    def getProfilingEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(profilingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AgentOrchestrationConfig
  ) extends zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly {
    override val profilingEnabled: Boolean = impl.profilingEnabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AgentOrchestrationConfig
  ): zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly =
    new Wrapper(impl)
}
