package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters.*
sealed trait ComputePlatform {
  def unwrap
      : software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform
}
object ComputePlatform {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform
  ): zio.aws.codeguruprofiler.model.ComputePlatform = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform.DEFAULT =>
      val r = Default
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform.AWS_LAMBDA =>
      val r = AWSLambda
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform =
      software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object Default extends zio.aws.codeguruprofiler.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform =
      software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform.DEFAULT
  }
  case object AWSLambda extends zio.aws.codeguruprofiler.model.ComputePlatform {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform =
      software.amazon.awssdk.services.codeguruprofiler.model.ComputePlatform.AWS_LAMBDA
  }
}
