package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.RevisionId
import scala.jdk.CollectionConverters.*
final case class RemovePermissionResponse(
    policy: String,
    revisionId: RevisionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionResponse = {
    import RemovePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionResponse
      .builder()
      .policy(policy: java.lang.String)
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.RemovePermissionResponse
      .wrap(buildAwsValue())
}
object RemovePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.RemovePermissionResponse =
      zio.aws.codeguruprofiler.model
        .RemovePermissionResponse(policy, revisionId)
    def policy: String
    def revisionId: RevisionId
    def getPolicy: ZIO[Any, Nothing, String] = ZIO.succeed(policy)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionResponse
  ) extends zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly {
    override val policy: String = impl.policy(): String
    override val revisionId: RevisionId =
      zio.aws.codeguruprofiler.model.primitives.RevisionId(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionResponse
  ): zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly =
    new Wrapper(impl)
}
