package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.{ProfilingGroupName, ChannelId}
import scala.jdk.CollectionConverters.*
final case class RemoveNotificationChannelRequest(
    channelId: ChannelId,
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest = {
    import RemoveNotificationChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest
      .builder()
      .channelId(ChannelId.unwrap(channelId): java.lang.String)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.RemoveNotificationChannelRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.RemoveNotificationChannelRequest
      .wrap(buildAwsValue())
}
object RemoveNotificationChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.RemoveNotificationChannelRequest =
      zio.aws.codeguruprofiler.model
        .RemoveNotificationChannelRequest(channelId, profilingGroupName)
    def channelId: ChannelId
    def profilingGroupName: ProfilingGroupName
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest
  ) extends zio.aws.codeguruprofiler.model.RemoveNotificationChannelRequest.ReadOnly {
    override val channelId: ChannelId =
      zio.aws.codeguruprofiler.model.primitives.ChannelId(impl.channelId())
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest
  ): zio.aws.codeguruprofiler.model.RemoveNotificationChannelRequest.ReadOnly =
    new Wrapper(impl)
}
