package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.{Timestamp, Integer}
import scala.jdk.CollectionConverters.*
final case class Recommendation(
    allMatchesCount: Integer,
    allMatchesSum: Double,
    endTime: Timestamp,
    pattern: zio.aws.codeguruprofiler.model.Pattern,
    startTime: Timestamp,
    topMatches: Iterable[zio.aws.codeguruprofiler.model.Match]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.Recommendation
      .builder()
      .allMatchesCount(allMatchesCount: java.lang.Integer)
      .allMatchesSum(allMatchesSum: java.lang.Double)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .pattern(pattern.buildAwsValue())
      .startTime(Timestamp.unwrap(startTime): Instant)
      .topMatches(topMatches.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.Recommendation.ReadOnly =
    zio.aws.codeguruprofiler.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.Recommendation =
      zio.aws.codeguruprofiler.model.Recommendation(
        allMatchesCount,
        allMatchesSum,
        endTime,
        pattern.asEditable,
        startTime,
        topMatches.map { item =>
          item.asEditable
        }
      )
    def allMatchesCount: Integer
    def allMatchesSum: Double
    def endTime: Timestamp
    def pattern: zio.aws.codeguruprofiler.model.Pattern.ReadOnly
    def startTime: Timestamp
    def topMatches: List[zio.aws.codeguruprofiler.model.Match.ReadOnly]
    def getAllMatchesCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(allMatchesCount)
    def getAllMatchesSum: ZIO[Any, Nothing, Double] = ZIO.succeed(allMatchesSum)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getPattern
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.Pattern.ReadOnly] =
      ZIO.succeed(pattern)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getTopMatches: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.Match.ReadOnly
    ]] = ZIO.succeed(topMatches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Recommendation
  ) extends zio.aws.codeguruprofiler.model.Recommendation.ReadOnly {
    override val allMatchesCount: Integer = impl.allMatchesCount(): Integer
    override val allMatchesSum: Double = impl.allMatchesSum(): Double
    override val endTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.endTime())
    override val pattern: zio.aws.codeguruprofiler.model.Pattern.ReadOnly =
      zio.aws.codeguruprofiler.model.Pattern.wrap(impl.pattern())
    override val startTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.startTime())
    override val topMatches
        : List[zio.aws.codeguruprofiler.model.Match.ReadOnly] = impl
      .topMatches()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.Match.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Recommendation
  ): zio.aws.codeguruprofiler.model.Recommendation.ReadOnly = new Wrapper(impl)
}
