package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  PaginationToken,
  MaxResults,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFindingsReportsRequest(
    dailyReportsOnly: Optional[Boolean] = Optional.Absent,
    endTime: Timestamp,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    profilingGroupName: ProfilingGroupName,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest = {
    import ListFindingsReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest
      .builder()
      .optionallyWith(dailyReportsOnly.map(value => value: java.lang.Boolean))(
        _.dailyReportsOnly
      )
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListFindingsReportsRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.ListFindingsReportsRequest
      .wrap(buildAwsValue())
}
object ListFindingsReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListFindingsReportsRequest =
      zio.aws.codeguruprofiler.model.ListFindingsReportsRequest(
        dailyReportsOnly.map(value => value),
        endTime,
        maxResults.map(value => value),
        nextToken.map(value => value),
        profilingGroupName,
        startTime
      )
    def dailyReportsOnly: Optional[Boolean]
    def endTime: Timestamp
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def profilingGroupName: ProfilingGroupName
    def startTime: Timestamp
    def getDailyReportsOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dailyReportsOnly", dailyReportsOnly)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest
  ) extends zio.aws.codeguruprofiler.model.ListFindingsReportsRequest.ReadOnly {
    override val dailyReportsOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dailyReportsOnly())
      .map(value => value: Boolean)
    override val endTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.endTime())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codeguruprofiler.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val startTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest
  ): zio.aws.codeguruprofiler.model.ListFindingsReportsRequest.ReadOnly =
    new Wrapper(impl)
}
