package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class TimestampStructure(value: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.TimestampStructure = {
    import TimestampStructure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.TimestampStructure
      .builder()
      .value(Timestamp.unwrap(value): Instant)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly =
    zio.aws.codeguruprofiler.model.TimestampStructure.wrap(buildAwsValue())
}
object TimestampStructure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.TimestampStructure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.TimestampStructure =
      zio.aws.codeguruprofiler.model.TimestampStructure(value)
    def value: Timestamp
    def getValue: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.TimestampStructure
  ) extends zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly {
    override val value: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.TimestampStructure
  ): zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly = new Wrapper(
    impl
  )
}
