package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.FrameMetricValue
import scala.jdk.CollectionConverters.*
final case class FrameMetricDatum(
    frameMetric: zio.aws.codeguruprofiler.model.FrameMetric,
    values: Iterable[FrameMetricValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDatum = {
    import FrameMetricDatum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDatum
      .builder()
      .frameMetric(frameMetric.buildAwsValue())
      .values(values.map { item =>
        FrameMetricValue.unwrap(item): java.lang.Double
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.FrameMetricDatum.ReadOnly =
    zio.aws.codeguruprofiler.model.FrameMetricDatum.wrap(buildAwsValue())
}
object FrameMetricDatum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDatum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.FrameMetricDatum =
      zio.aws.codeguruprofiler.model
        .FrameMetricDatum(frameMetric.asEditable, values)
    def frameMetric: zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly
    def values: List[FrameMetricValue]
    def getFrameMetric: ZIO[
      Any,
      Nothing,
      zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly
    ] = ZIO.succeed(frameMetric)
    def getValues: ZIO[Any, Nothing, List[FrameMetricValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDatum
  ) extends zio.aws.codeguruprofiler.model.FrameMetricDatum.ReadOnly {
    override val frameMetric
        : zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly =
      zio.aws.codeguruprofiler.model.FrameMetric.wrap(impl.frameMetric())
    override val values: List[FrameMetricValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.primitives.FrameMetricValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricDatum
  ): zio.aws.codeguruprofiler.model.FrameMetricDatum.ReadOnly = new Wrapper(
    impl
  )
}
