package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName
import scala.jdk.CollectionConverters.*
final case class DescribeProfilingGroupRequest(
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest = {
    import DescribeProfilingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest
      .builder()
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.DescribeProfilingGroupRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.DescribeProfilingGroupRequest
      .wrap(buildAwsValue())
}
object DescribeProfilingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.DescribeProfilingGroupRequest =
      zio.aws.codeguruprofiler.model
        .DescribeProfilingGroupRequest(profilingGroupName)
    def profilingGroupName: ProfilingGroupName
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest
  ) extends zio.aws.codeguruprofiler.model.DescribeProfilingGroupRequest.ReadOnly {
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest
  ): zio.aws.codeguruprofiler.model.DescribeProfilingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
