package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Period,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BatchGetFrameMetricDataRequest(
    endTime: Optional[Timestamp] = Optional.Absent,
    frameMetrics: Optional[
      Iterable[zio.aws.codeguruprofiler.model.FrameMetric]
    ] = Optional.Absent,
    period: Optional[Period] = Optional.Absent,
    profilingGroupName: ProfilingGroupName,
    startTime: Optional[Timestamp] = Optional.Absent,
    targetResolution: Optional[
      zio.aws.codeguruprofiler.model.AggregationPeriod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest = {
    import BatchGetFrameMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        frameMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameMetrics)
      .optionallyWith(
        period.map(value => Period.unwrap(value): java.lang.String)
      )(_.period)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(targetResolution.map(value => value.unwrap))(
        _.targetResolution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest
      .wrap(buildAwsValue())
}
object BatchGetFrameMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest =
      zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest(
        endTime.map(value => value),
        frameMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        period.map(value => value),
        profilingGroupName,
        startTime.map(value => value),
        targetResolution.map(value => value)
      )
    def endTime: Optional[Timestamp]
    def frameMetrics
        : Optional[List[zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly]]
    def period: Optional[Period]
    def profilingGroupName: ProfilingGroupName
    def startTime: Optional[Timestamp]
    def targetResolution
        : Optional[zio.aws.codeguruprofiler.model.AggregationPeriod]
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getFrameMetrics: ZIO[Any, AwsError, List[
      zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("frameMetrics", frameMetrics)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTargetResolution
        : ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.AggregationPeriod] =
      AwsError.unwrapOptionField("targetResolution", targetResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
  ) extends zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val frameMetrics
        : Optional[List[zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeguruprofiler.model.FrameMetric.wrap(item)
          }.toList
        )
    override val period: Optional[Period] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Period(value))
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val targetResolution
        : Optional[zio.aws.codeguruprofiler.model.AggregationPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResolution())
        .map(value =>
          zio.aws.codeguruprofiler.model.AggregationPeriod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
  ): zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
