package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName
import scala.jdk.CollectionConverters.*
final case class AddNotificationChannelsRequest(
    channels: Iterable[zio.aws.codeguruprofiler.model.Channel],
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest = {
    import AddNotificationChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest
      .builder()
      .channels(channels.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.AddNotificationChannelsRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.AddNotificationChannelsRequest
      .wrap(buildAwsValue())
}
object AddNotificationChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.AddNotificationChannelsRequest =
      zio.aws.codeguruprofiler.model.AddNotificationChannelsRequest(
        channels.map { item =>
          item.asEditable
        },
        profilingGroupName
      )
    def channels: List[zio.aws.codeguruprofiler.model.Channel.ReadOnly]
    def profilingGroupName: ProfilingGroupName
    def getChannels: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.Channel.ReadOnly
    ]] = ZIO.succeed(channels)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest
  ) extends zio.aws.codeguruprofiler.model.AddNotificationChannelsRequest.ReadOnly {
    override val channels
        : List[zio.aws.codeguruprofiler.model.Channel.ReadOnly] = impl
      .channels()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.Channel.wrap(item)
      }
      .toList
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest
  ): zio.aws.codeguruprofiler.model.AddNotificationChannelsRequest.ReadOnly =
    new Wrapper(impl)
}
