package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters.*
sealed trait FeedbackType {
  def unwrap
      : software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType
}
object FeedbackType {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType
  ): zio.aws.codeguruprofiler.model.FeedbackType = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType.POSITIVE =>
      val r = Positive
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType.NEGATIVE =>
      val r = Negative
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.FeedbackType {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType =
      software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType.UNKNOWN_TO_SDK_VERSION
  }
  case object Positive extends zio.aws.codeguruprofiler.model.FeedbackType {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType =
      software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType.POSITIVE
  }
  case object Negative extends zio.aws.codeguruprofiler.model.FeedbackType {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType =
      software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType.NEGATIVE
  }
}
