package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Anomaly(
    instances: Iterable[zio.aws.codeguruprofiler.model.AnomalyInstance],
    metric: zio.aws.codeguruprofiler.model.Metric,
    reason: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.Anomaly = {
    import Anomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.Anomaly
      .builder()
      .instances(instances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .metric(metric.buildAwsValue())
      .reason(reason: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.Anomaly.ReadOnly =
    zio.aws.codeguruprofiler.model.Anomaly.wrap(buildAwsValue())
}
object Anomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.Anomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.Anomaly =
      zio.aws.codeguruprofiler.model.Anomaly(
        instances.map { item =>
          item.asEditable
        },
        metric.asEditable,
        reason
      )
    def instances: List[zio.aws.codeguruprofiler.model.AnomalyInstance.ReadOnly]
    def metric: zio.aws.codeguruprofiler.model.Metric.ReadOnly
    def reason: String
    def getInstances: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.AnomalyInstance.ReadOnly
    ]] = ZIO.succeed(instances)
    def getMetric
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.Metric.ReadOnly] =
      ZIO.succeed(metric)
    def getReason: ZIO[Any, Nothing, String] = ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Anomaly
  ) extends zio.aws.codeguruprofiler.model.Anomaly.ReadOnly {
    override val instances
        : List[zio.aws.codeguruprofiler.model.AnomalyInstance.ReadOnly] = impl
      .instances()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.AnomalyInstance.wrap(item)
      }
      .toList
    override val metric: zio.aws.codeguruprofiler.model.Metric.ReadOnly =
      zio.aws.codeguruprofiler.model.Metric.wrap(impl.metric())
    override val reason: String = impl.reason(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Anomaly
  ): zio.aws.codeguruprofiler.model.Anomaly.ReadOnly = new Wrapper(impl)
}
