package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Timestamp,
  ProfilingGroupArn
}
import scala.jdk.CollectionConverters.*
final case class ProfilingGroupDescription(
    agentOrchestrationConfig: Option[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig
    ] = None,
    arn: Option[ProfilingGroupArn] = None,
    computePlatform: Option[zio.aws.codeguruprofiler.model.ComputePlatform] =
      None,
    createdAt: Option[Timestamp] = None,
    name: Option[ProfilingGroupName] = None,
    profilingStatus: Option[zio.aws.codeguruprofiler.model.ProfilingStatus] =
      None,
    tags: Option[Map[String, String]] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription = {
    import ProfilingGroupDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
      .builder()
      .optionallyWith(
        agentOrchestrationConfig.map(value => value.buildAwsValue())
      )(_.agentOrchestrationConfig)
      .optionallyWith(
        arn.map(value => ProfilingGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        name.map(value => ProfilingGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(profilingStatus.map(value => value.buildAwsValue()))(
        _.profilingStatus
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly =
    zio.aws.codeguruprofiler.model.ProfilingGroupDescription
      .wrap(buildAwsValue())
}
object ProfilingGroupDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ProfilingGroupDescription =
      zio.aws.codeguruprofiler.model.ProfilingGroupDescription(
        agentOrchestrationConfig.map(value => value.asEditable),
        arn.map(value => value),
        computePlatform.map(value => value),
        createdAt.map(value => value),
        name.map(value => value),
        profilingStatus.map(value => value.asEditable),
        tags.map(value => value),
        updatedAt.map(value => value)
      )
    def agentOrchestrationConfig: Option[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ]
    def arn: Option[ProfilingGroupArn]
    def computePlatform: Option[zio.aws.codeguruprofiler.model.ComputePlatform]
    def createdAt: Option[Timestamp]
    def name: Option[ProfilingGroupName]
    def profilingStatus
        : Option[zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly]
    def tags: Option[Map[String, String]]
    def updatedAt: Option[Timestamp]
    def getAgentOrchestrationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "agentOrchestrationConfig",
      agentOrchestrationConfig
    )
    def getArn: ZIO[Any, AwsError, ProfilingGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getName: ZIO[Any, AwsError, ProfilingGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getProfilingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly
    ] = AwsError.unwrapOptionField("profilingStatus", profilingStatus)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
  ) extends zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly {
    override val agentOrchestrationConfig: Option[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = scala
      .Option(impl.agentOrchestrationConfig())
      .map(value =>
        zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.wrap(value)
      )
    override val arn: Option[ProfilingGroupArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.ProfilingGroupArn(value)
      )
    override val computePlatform
        : Option[zio.aws.codeguruprofiler.model.ComputePlatform] = scala
      .Option(impl.computePlatform())
      .map(value => zio.aws.codeguruprofiler.model.ComputePlatform.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val name: Option[ProfilingGroupName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName(value)
      )
    override val profilingStatus
        : Option[zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly] =
      scala
        .Option(impl.profilingStatus())
        .map(value =>
          zio.aws.codeguruprofiler.model.ProfilingStatus.wrap(value)
        )
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
  ): zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly =
    new Wrapper(impl)
}
