package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Period,
  MaxDepth,
  Timestamp
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetProfileRequest(
    accept: Option[String] = None,
    endTime: Option[Timestamp] = None,
    maxDepth: Option[MaxDepth] = None,
    period: Option[Period] = None,
    profilingGroupName: ProfilingGroupName,
    startTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest = {
    import GetProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest
      .builder()
      .optionallyWith(accept.map(value => value: java.lang.String))(_.accept)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(maxDepth.map(value => MaxDepth.unwrap(value): Integer))(
        _.maxDepth
      )
      .optionallyWith(
        period.map(value => Period.unwrap(value): java.lang.String)
      )(_.period)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.GetProfileRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.GetProfileRequest.wrap(buildAwsValue())
}
object GetProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.GetProfileRequest =
      zio.aws.codeguruprofiler.model.GetProfileRequest(
        accept.map(value => value),
        endTime.map(value => value),
        maxDepth.map(value => value),
        period.map(value => value),
        profilingGroupName,
        startTime.map(value => value)
      )
    def accept: Option[String]
    def endTime: Option[Timestamp]
    def maxDepth: Option[MaxDepth]
    def period: Option[Period]
    def profilingGroupName: ProfilingGroupName
    def startTime: Option[Timestamp]
    def getAccept: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accept", accept)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxDepth: ZIO[Any, AwsError, MaxDepth] =
      AwsError.unwrapOptionField("maxDepth", maxDepth)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest
  ) extends zio.aws.codeguruprofiler.model.GetProfileRequest.ReadOnly {
    override val accept: Option[String] =
      scala.Option(impl.accept()).map(value => value: String)
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val maxDepth: Option[MaxDepth] = scala
      .Option(impl.maxDepth())
      .map(value => zio.aws.codeguruprofiler.model.primitives.MaxDepth(value))
    override val period: Option[Period] = scala
      .Option(impl.period())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Period(value))
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest
  ): zio.aws.codeguruprofiler.model.GetProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
