package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  PaginationToken,
  MaxResults,
  Timestamp
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListProfileTimesRequest(
    endTime: Timestamp,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None,
    orderBy: Option[zio.aws.codeguruprofiler.model.OrderBy] = None,
    period: zio.aws.codeguruprofiler.model.AggregationPeriod,
    profilingGroupName: ProfilingGroupName,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest = {
    import ListProfileTimesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .period(period.unwrap)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListProfileTimesRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.ListProfileTimesRequest.wrap(buildAwsValue())
}
object ListProfileTimesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListProfileTimesRequest =
      zio.aws.codeguruprofiler.model.ListProfileTimesRequest(
        endTime,
        maxResults.map(value => value),
        nextToken.map(value => value),
        orderBy.map(value => value),
        period,
        profilingGroupName,
        startTime
      )
    def endTime: Timestamp
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def orderBy: Option[zio.aws.codeguruprofiler.model.OrderBy]
    def period: zio.aws.codeguruprofiler.model.AggregationPeriod
    def profilingGroupName: ProfilingGroupName
    def startTime: Timestamp
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
    def getPeriod
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.AggregationPeriod] =
      ZIO.succeed(period)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest
  ) extends zio.aws.codeguruprofiler.model.ListProfileTimesRequest.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.endTime())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codeguruprofiler.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
    override val orderBy: Option[zio.aws.codeguruprofiler.model.OrderBy] = scala
      .Option(impl.orderBy())
      .map(value => zio.aws.codeguruprofiler.model.OrderBy.wrap(value))
    override val period: zio.aws.codeguruprofiler.model.AggregationPeriod =
      zio.aws.codeguruprofiler.model.AggregationPeriod.wrap(impl.period())
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val startTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest
  ): zio.aws.codeguruprofiler.model.ListProfileTimesRequest.ReadOnly =
    new Wrapper(impl)
}
