package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RemoveNotificationChannelResponse(
    notificationConfiguration: Option[
      zio.aws.codeguruprofiler.model.NotificationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelResponse = {
    import RemoveNotificationChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelResponse
      .builder()
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse
      .wrap(buildAwsValue())
}
object RemoveNotificationChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse =
      zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse(
        notificationConfiguration.map(value => value.asEditable)
      )
    def notificationConfiguration: Option[
      zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly
    ]
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelResponse
  ) extends zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly {
    override val notificationConfiguration: Option[
      zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly
    ] = scala
      .Option(impl.notificationConfiguration())
      .map(value =>
        zio.aws.codeguruprofiler.model.NotificationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelResponse
  ): zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly =
    new Wrapper(impl)
}
