package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Period,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class BatchGetFrameMetricDataRequest(
    endTime: Option[Timestamp] = None,
    frameMetrics: Option[Iterable[zio.aws.codeguruprofiler.model.FrameMetric]] =
      None,
    period: Option[Period] = None,
    profilingGroupName: ProfilingGroupName,
    startTime: Option[Timestamp] = None,
    targetResolution: Option[zio.aws.codeguruprofiler.model.AggregationPeriod] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest = {
    import BatchGetFrameMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        frameMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameMetrics)
      .optionallyWith(
        period.map(value => Period.unwrap(value): java.lang.String)
      )(_.period)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(targetResolution.map(value => value.unwrap))(
        _.targetResolution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest
      .wrap(buildAwsValue())
}
object BatchGetFrameMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest =
      zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest(
        endTime.map(value => value),
        frameMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        period.map(value => value),
        profilingGroupName,
        startTime.map(value => value),
        targetResolution.map(value => value)
      )
    def endTime: Option[Timestamp]
    def frameMetrics
        : Option[List[zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly]]
    def period: Option[Period]
    def profilingGroupName: ProfilingGroupName
    def startTime: Option[Timestamp]
    def targetResolution
        : Option[zio.aws.codeguruprofiler.model.AggregationPeriod]
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getFrameMetrics: ZIO[Any, AwsError, List[
      zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("frameMetrics", frameMetrics)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTargetResolution
        : ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.AggregationPeriod] =
      AwsError.unwrapOptionField("targetResolution", targetResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
  ) extends zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest.ReadOnly {
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val frameMetrics
        : Option[List[zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly]] =
      scala
        .Option(impl.frameMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeguruprofiler.model.FrameMetric.wrap(item)
          }.toList
        )
    override val period: Option[Period] = scala
      .Option(impl.period())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Period(value))
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val targetResolution
        : Option[zio.aws.codeguruprofiler.model.AggregationPeriod] = scala
      .Option(impl.targetResolution())
      .map(value =>
        zio.aws.codeguruprofiler.model.AggregationPeriod.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
  ): zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
