package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class ProfilingStatus(
    latestAgentOrchestratedAt: Option[Timestamp] = None,
    latestAgentProfileReportedAt: Option[Timestamp] = None,
    latestAggregatedProfile: Option[
      zio.aws.codeguruprofiler.model.AggregatedProfileTime
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus = {
    import ProfilingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
      .builder()
      .optionallyWith(
        latestAgentOrchestratedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestAgentOrchestratedAt)
      .optionallyWith(
        latestAgentProfileReportedAt.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.latestAgentProfileReportedAt)
      .optionallyWith(
        latestAggregatedProfile.map(value => value.buildAwsValue())
      )(_.latestAggregatedProfile)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly =
    zio.aws.codeguruprofiler.model.ProfilingStatus.wrap(buildAwsValue())
}
object ProfilingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ProfilingStatus =
      zio.aws.codeguruprofiler.model.ProfilingStatus(
        latestAgentOrchestratedAt.map(value => value),
        latestAgentProfileReportedAt.map(value => value),
        latestAggregatedProfile.map(value => value.asEditable)
      )
    def latestAgentOrchestratedAt: Option[Timestamp]
    def latestAgentProfileReportedAt: Option[Timestamp]
    def latestAggregatedProfile
        : Option[zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly]
    def getLatestAgentOrchestratedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("latestAgentOrchestratedAt", latestAgentOrchestratedAt)
    def getLatestAgentProfileReportedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "latestAgentProfileReportedAt",
        latestAgentProfileReportedAt
      )
    def getLatestAggregatedProfile: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly
    ] = AwsError.unwrapOptionField(
      "latestAggregatedProfile",
      latestAggregatedProfile
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
  ) extends zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly {
    override val latestAgentOrchestratedAt: Option[Timestamp] = scala
      .Option(impl.latestAgentOrchestratedAt())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val latestAgentProfileReportedAt: Option[Timestamp] = scala
      .Option(impl.latestAgentProfileReportedAt())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val latestAggregatedProfile: Option[
      zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly
    ] = scala
      .Option(impl.latestAggregatedProfile())
      .map(value =>
        zio.aws.codeguruprofiler.model.AggregatedProfileTime.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
  ): zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly = new Wrapper(impl)
}
