package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class AnomalyInstance(
    endTime: Option[Timestamp] = None,
    id: String,
    startTime: Timestamp,
    userFeedback: Option[zio.aws.codeguruprofiler.model.UserFeedback] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstance = {
    import AnomalyInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstance
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .id(id: java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(userFeedback.map(value => value.buildAwsValue()))(
        _.userFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.AnomalyInstance.ReadOnly =
    zio.aws.codeguruprofiler.model.AnomalyInstance.wrap(buildAwsValue())
}
object AnomalyInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.AnomalyInstance =
      zio.aws.codeguruprofiler.model.AnomalyInstance(
        endTime.map(value => value),
        id,
        startTime,
        userFeedback.map(value => value.asEditable)
      )
    def endTime: Option[Timestamp]
    def id: String
    def startTime: Timestamp
    def userFeedback
        : Option[zio.aws.codeguruprofiler.model.UserFeedback.ReadOnly]
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getUserFeedback: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.UserFeedback.ReadOnly
    ] = AwsError.unwrapOptionField("userFeedback", userFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstance
  ) extends zio.aws.codeguruprofiler.model.AnomalyInstance.ReadOnly {
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val id: String = impl.id(): String
    override val startTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.startTime())
    override val userFeedback
        : Option[zio.aws.codeguruprofiler.model.UserFeedback.ReadOnly] = scala
      .Option(impl.userFeedback())
      .map(value => zio.aws.codeguruprofiler.model.UserFeedback.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AnomalyInstance
  ): zio.aws.codeguruprofiler.model.AnomalyInstance.ReadOnly = new Wrapper(impl)
}
