package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.{
  Integer,
  Timestamp,
  FindingsReportId
}
import scala.jdk.CollectionConverters.*
final case class FindingsReportSummary(
    id: Option[FindingsReportId] = None,
    profileEndTime: Option[Timestamp] = None,
    profileStartTime: Option[Timestamp] = None,
    profilingGroupName: Option[String] = None,
    totalNumberOfFindings: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary = {
    import FindingsReportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
      .builder()
      .optionallyWith(
        id.map(value => FindingsReportId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        profileEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.profileEndTime)
      .optionallyWith(
        profileStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.profileStartTime)
      .optionallyWith(profilingGroupName.map(value => value: java.lang.String))(
        _.profilingGroupName
      )
      .optionallyWith(
        totalNumberOfFindings.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalNumberOfFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly =
    zio.aws.codeguruprofiler.model.FindingsReportSummary.wrap(buildAwsValue())
}
object FindingsReportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.FindingsReportSummary =
      zio.aws.codeguruprofiler.model.FindingsReportSummary(
        id.map(value => value),
        profileEndTime.map(value => value),
        profileStartTime.map(value => value),
        profilingGroupName.map(value => value),
        totalNumberOfFindings.map(value => value)
      )
    def id: Option[FindingsReportId]
    def profileEndTime: Option[Timestamp]
    def profileStartTime: Option[Timestamp]
    def profilingGroupName: Option[String]
    def totalNumberOfFindings: Option[Integer]
    def getId: ZIO[Any, AwsError, FindingsReportId] =
      AwsError.unwrapOptionField("id", id)
    def getProfileEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("profileEndTime", profileEndTime)
    def getProfileStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("profileStartTime", profileStartTime)
    def getProfilingGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("profilingGroupName", profilingGroupName)
    def getTotalNumberOfFindings: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNumberOfFindings", totalNumberOfFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
  ) extends zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly {
    override val id: Option[FindingsReportId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.FindingsReportId(value)
      )
    override val profileEndTime: Option[Timestamp] = scala
      .Option(impl.profileEndTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val profileStartTime: Option[Timestamp] = scala
      .Option(impl.profileStartTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val profilingGroupName: Option[String] =
      scala.Option(impl.profilingGroupName()).map(value => value: String)
    override val totalNumberOfFindings: Option[Integer] = scala
      .Option(impl.totalNumberOfFindings())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
  ): zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly =
    new Wrapper(impl)
}
