package zio.aws.codeguruprofiler.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.{PaginationToken, MaxResults}
import scala.jdk.CollectionConverters.*
final case class GetFindingsReportAccountSummaryRequest(
    dailyReportsOnly: Option[Boolean] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest = {
    import GetFindingsReportAccountSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
      .builder()
      .optionallyWith(dailyReportsOnly.map(value => value: java.lang.Boolean))(
        _.dailyReportsOnly
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
      .wrap(buildAwsValue())
}
object GetFindingsReportAccountSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest =
      zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest(
        dailyReportsOnly.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dailyReportsOnly: Option[Boolean]
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def getDailyReportsOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dailyReportsOnly", dailyReportsOnly)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
  ) extends zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest.ReadOnly {
    override val dailyReportsOnly: Option[Boolean] =
      scala.Option(impl.dailyReportsOnly()).map(value => value: Boolean)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codeguruprofiler.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
  ): zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
