package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters.*
sealed trait AggregationPeriod {
  def unwrap
      : software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod
}
object AggregationPeriod {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod
  ): zio.aws.codeguruprofiler.model.AggregationPeriod = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.PT5_M =>
      val r = PT5M
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.PT1_H =>
      val r = PT1H
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.P1_D =>
      val r = P1D
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.AggregationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod =
      software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.UNKNOWN_TO_SDK_VERSION
  }
  case object PT5M extends zio.aws.codeguruprofiler.model.AggregationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod =
      software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.PT5_M
  }
  case object PT1H extends zio.aws.codeguruprofiler.model.AggregationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod =
      software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.PT1_H
  }
  case object P1D extends zio.aws.codeguruprofiler.model.AggregationPeriod {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod =
      software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod.P1_D
  }
}
