package zio.aws.codeguruprofiler
import zio.aws.codeguruprofiler.model.primitives.FindingsReportId.Type
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Principal,
  FrameMetricValue
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AgentProfile extends Subtype[Chunk[Byte]]
    type AgentProfile =
      zio.aws.codeguruprofiler.model.primitives.AgentProfile.Type
    object AggregatedProfile extends Subtype[Chunk[Byte]]
    type AggregatedProfile =
      zio.aws.codeguruprofiler.model.primitives.AggregatedProfile.Type
    object AnomalyInstanceId extends Subtype[String]
    type AnomalyInstanceId =
      zio.aws.codeguruprofiler.model.primitives.AnomalyInstanceId.Type
    object ChannelId extends Subtype[String]
    type ChannelId = zio.aws.codeguruprofiler.model.primitives.ChannelId.Type
    object ChannelUri extends Subtype[String]
    type ChannelUri = zio.aws.codeguruprofiler.model.primitives.ChannelUri.Type
    object ClientToken extends Subtype[String]
    type ClientToken =
      zio.aws.codeguruprofiler.model.primitives.ClientToken.Type
    object FindingsReportId extends Subtype[String]
    type FindingsReportId =
      zio.aws.codeguruprofiler.model.primitives.FindingsReportId.Type
    object FleetInstanceId extends Subtype[String]
    type FleetInstanceId =
      zio.aws.codeguruprofiler.model.primitives.FleetInstanceId.Type
    object FrameMetricValue extends Subtype[Double]
    type FrameMetricValue =
      zio.aws.codeguruprofiler.model.primitives.FrameMetricValue.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.codeguruprofiler.model.primitives.Integer.Type
    object Locale extends Subtype[String]
    type Locale = zio.aws.codeguruprofiler.model.primitives.Locale.Type
    object MaxDepth extends Subtype[Int]
    type MaxDepth = zio.aws.codeguruprofiler.model.primitives.MaxDepth.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.codeguruprofiler.model.primitives.MaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.codeguruprofiler.model.primitives.PaginationToken.Type
    object Percentage extends Subtype[Double]
    type Percentage = zio.aws.codeguruprofiler.model.primitives.Percentage.Type
    object Period extends Subtype[String]
    type Period = zio.aws.codeguruprofiler.model.primitives.Period.Type
    object Principal extends Subtype[String]
    type Principal = zio.aws.codeguruprofiler.model.primitives.Principal.Type
    object ProfilingGroupArn extends Subtype[String]
    type ProfilingGroupArn =
      zio.aws.codeguruprofiler.model.primitives.ProfilingGroupArn.Type
    object ProfilingGroupName extends Subtype[String]
    type ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName.Type
    object RevisionId extends Subtype[String]
    type RevisionId = zio.aws.codeguruprofiler.model.primitives.RevisionId.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.codeguruprofiler.model.primitives.Timestamp.Type
  }
  type AgentParameters =
    Map[zio.aws.codeguruprofiler.model.AgentParameterField, String]
  type Anomalies = List[zio.aws.codeguruprofiler.model.Anomaly]
  type AnomalyInstances = List[zio.aws.codeguruprofiler.model.AnomalyInstance]
  type Channels = List[zio.aws.codeguruprofiler.model.Channel]
  type EventPublishers = List[zio.aws.codeguruprofiler.model.EventPublisher]
  type FindingsReportSummaries =
    List[zio.aws.codeguruprofiler.model.FindingsReportSummary]
  type FrameMetricData = List[zio.aws.codeguruprofiler.model.FrameMetricDatum]
  type FrameMetricValues = List[FrameMetricValue]
  type FrameMetrics = List[zio.aws.codeguruprofiler.model.FrameMetric]
  type ListOfTimestamps =
    List[zio.aws.codeguruprofiler.model.TimestampStructure]
  type Matches = List[zio.aws.codeguruprofiler.model.Match]
  type Metadata = Map[zio.aws.codeguruprofiler.model.MetadataField, String]
  type Principals = List[Principal]
  type ProfileTimes = List[zio.aws.codeguruprofiler.model.ProfileTime]
  type ProfilingGroupDescriptions =
    List[zio.aws.codeguruprofiler.model.ProfilingGroupDescription]
  type ProfilingGroupNames = List[ProfilingGroupName]
  type Recommendations = List[zio.aws.codeguruprofiler.model.Recommendation]
  type Strings = List[String]
  type TagKeys = List[String]
  type TagsMap = Map[String, String]
  type TargetFrame = List[String]
  type TargetFrames = List[Iterable[String]]
  type ThreadStates = List[String]
  type UnprocessedEndTimeMap =
    Map[String, Iterable[zio.aws.codeguruprofiler.model.TimestampStructure]]
}
