package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListProfileTimesResponse(
    nextToken: Option[PaginationToken] = None,
    profileTimes: Iterable[zio.aws.codeguruprofiler.model.ProfileTime]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse = {
    import ListProfileTimesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .profileTimes(profileTimes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.ListProfileTimesResponse
      .wrap(buildAwsValue())
}
object ListProfileTimesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListProfileTimesResponse =
      zio.aws.codeguruprofiler.model.ListProfileTimesResponse(
        nextToken.map(value => value),
        profileTimes.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[PaginationToken]
    def profileTimes: List[zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProfileTimes: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly
    ]] = ZIO.succeed(profileTimes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse
  ) extends zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
    override val profileTimes
        : List[zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly] = impl
      .profileTimes()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.ProfileTime.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse
  ): zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly =
    new Wrapper(impl)
}
