package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  ClientToken,
  AgentProfile
}
import scala.jdk.CollectionConverters._
final case class PostAgentProfileRequest(
    agentProfile: AgentProfile,
    contentType: String,
    profileToken: Optional[ClientToken] = Optional.Absent,
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest = {
    import PostAgentProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest
      .builder()
      .agentProfile(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(agentProfile.toArray[Byte])
      )
      .contentType(contentType: java.lang.String)
      .optionallyWith(
        profileToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.profileToken)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.PostAgentProfileRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.PostAgentProfileRequest.wrap(buildAwsValue())
}
object PostAgentProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.PostAgentProfileRequest =
      zio.aws.codeguruprofiler.model.PostAgentProfileRequest(
        agentProfile,
        contentType,
        profileToken.map(value => value),
        profilingGroupName
      )
    def agentProfile: AgentProfile
    def contentType: String
    def profileToken: Optional[ClientToken]
    def profilingGroupName: ProfilingGroupName
    def getAgentProfile: ZIO[Any, Nothing, AgentProfile] =
      ZIO.succeed(agentProfile)
    def getContentType: ZIO[Any, Nothing, String] = ZIO.succeed(contentType)
    def getProfileToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("profileToken", profileToken)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest
  ) extends zio.aws.codeguruprofiler.model.PostAgentProfileRequest.ReadOnly {
    override val agentProfile: AgentProfile =
      zio.aws.codeguruprofiler.model.primitives.AgentProfile(
        zio.Chunk.fromArray(impl.agentProfile().asByteArrayUnsafe())
      )
    override val contentType: String = impl.contentType(): String
    override val profileToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.profileToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.ClientToken(value)
      )
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest
  ): zio.aws.codeguruprofiler.model.PostAgentProfileRequest.ReadOnly =
    new Wrapper(impl)
}
