package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  FleetInstanceId
}
import scala.jdk.CollectionConverters._
final case class ConfigureAgentRequest(
    fleetInstanceId: Optional[FleetInstanceId] = Optional.Absent,
    metadata: Optional[
      Map[zio.aws.codeguruprofiler.model.MetadataField, String]
    ] = Optional.Absent,
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest = {
    import ConfigureAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest
      .builder()
      .optionallyWith(
        fleetInstanceId.map(value =>
          FleetInstanceId.unwrap(value): java.lang.String
        )
      )(_.fleetInstanceId)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadataWithStrings)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ConfigureAgentRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.ConfigureAgentRequest.wrap(buildAwsValue())
}
object ConfigureAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ConfigureAgentRequest =
      zio.aws.codeguruprofiler.model.ConfigureAgentRequest(
        fleetInstanceId.map(value => value),
        metadata.map(value => value),
        profilingGroupName
      )
    def fleetInstanceId: Optional[FleetInstanceId]
    def metadata
        : Optional[Map[zio.aws.codeguruprofiler.model.MetadataField, String]]
    def profilingGroupName: ProfilingGroupName
    def getFleetInstanceId: ZIO[Any, AwsError, FleetInstanceId] =
      AwsError.unwrapOptionField("fleetInstanceId", fleetInstanceId)
    def getMetadata: ZIO[Any, AwsError, Map[
      zio.aws.codeguruprofiler.model.MetadataField,
      String
    ]] = AwsError.unwrapOptionField("metadata", metadata)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest
  ) extends zio.aws.codeguruprofiler.model.ConfigureAgentRequest.ReadOnly {
    override val fleetInstanceId: Optional[FleetInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetInstanceId())
        .map(value =>
          zio.aws.codeguruprofiler.model.primitives.FleetInstanceId(value)
        )
    override val metadata
        : Optional[Map[zio.aws.codeguruprofiler.model.MetadataField, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codeguruprofiler.model.MetadataField
                .wrap(key) -> (value: String)
            })
            .toMap
        )
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest
  ): zio.aws.codeguruprofiler.model.ConfigureAgentRequest.ReadOnly =
    new Wrapper(impl)
}
