package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.AggregatedProfile
import scala.jdk.CollectionConverters._
final case class GetProfileResponse(
    contentEncoding: Optional[String] = Optional.Absent,
    contentType: String,
    profile: AggregatedProfile
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse = {
    import GetProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse
      .builder()
      .optionallyWith(contentEncoding.map(value => value: java.lang.String))(
        _.contentEncoding
      )
      .contentType(contentType: java.lang.String)
      .profile(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(profile.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.GetProfileResponse.wrap(buildAwsValue())
}
object GetProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.GetProfileResponse =
      zio.aws.codeguruprofiler.model.GetProfileResponse(
        contentEncoding.map(value => value),
        contentType,
        profile
      )
    def contentEncoding: Optional[String]
    def contentType: String
    def profile: AggregatedProfile
    def getContentEncoding: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentType: ZIO[Any, Nothing, String] = ZIO.succeed(contentType)
    def getProfile: ZIO[Any, Nothing, AggregatedProfile] = ZIO.succeed(profile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse
  ) extends zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly {
    override val contentEncoding: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentEncoding())
      .map(value => value: String)
    override val contentType: String = impl.contentType(): String
    override val profile: AggregatedProfile =
      zio.aws.codeguruprofiler.model.primitives.AggregatedProfile(
        zio.Chunk.fromArray(impl.profile().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse
  ): zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
