package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName
import scala.jdk.CollectionConverters._
final case class GetPolicyRequest(profilingGroupName: ProfilingGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest = {
    import GetPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest
      .builder()
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.GetPolicyRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.GetPolicyRequest.wrap(buildAwsValue())
}
object GetPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.GetPolicyRequest =
      zio.aws.codeguruprofiler.model.GetPolicyRequest(profilingGroupName)
    def profilingGroupName: ProfilingGroupName
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest
  ) extends zio.aws.codeguruprofiler.model.GetPolicyRequest.ReadOnly {
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest
  ): zio.aws.codeguruprofiler.model.GetPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
