package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProfilingGroupResponse(
    profilingGroup: zio.aws.codeguruprofiler.model.ProfilingGroupDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse = {
    import DescribeProfilingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse
      .builder()
      .profilingGroup(profilingGroup.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse
      .wrap(buildAwsValue())
}
object DescribeProfilingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse =
      zio.aws.codeguruprofiler.model
        .DescribeProfilingGroupResponse(profilingGroup.asEditable)
    def profilingGroup
        : zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly
    def getProfilingGroup: ZIO[
      Any,
      Nothing,
      zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly
    ] = ZIO.succeed(profilingGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse
  ) extends zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly {
    override val profilingGroup
        : zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly =
      zio.aws.codeguruprofiler.model.ProfilingGroupDescription
        .wrap(impl.profilingGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse
  ): zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly =
    new Wrapper(impl)
}
