package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters._
sealed trait ActionGroup {
  def unwrap: software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup
}
object ActionGroup {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup
  ): zio.aws.codeguruprofiler.model.ActionGroup = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup.AGENT_PERMISSIONS =>
      val r = agentPermissions
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.ActionGroup {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup =
      software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup.UNKNOWN_TO_SDK_VERSION
  }
  case object agentPermissions
      extends zio.aws.codeguruprofiler.model.ActionGroup {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup =
      software.amazon.awssdk.services.codeguruprofiler.model.ActionGroup.AGENT_PERMISSIONS
  }
}
