package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Timestamp,
  ProfilingGroupArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProfilingGroupDescription(
    agentOrchestrationConfig: Optional[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig
    ] = Optional.Absent,
    arn: Optional[ProfilingGroupArn] = Optional.Absent,
    computePlatform: Optional[zio.aws.codeguruprofiler.model.ComputePlatform] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    name: Optional[ProfilingGroupName] = Optional.Absent,
    profilingStatus: Optional[zio.aws.codeguruprofiler.model.ProfilingStatus] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription = {
    import ProfilingGroupDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
      .builder()
      .optionallyWith(
        agentOrchestrationConfig.map(value => value.buildAwsValue())
      )(_.agentOrchestrationConfig)
      .optionallyWith(
        arn.map(value => ProfilingGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        name.map(value => ProfilingGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(profilingStatus.map(value => value.buildAwsValue()))(
        _.profilingStatus
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly =
    zio.aws.codeguruprofiler.model.ProfilingGroupDescription
      .wrap(buildAwsValue())
}
object ProfilingGroupDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ProfilingGroupDescription =
      zio.aws.codeguruprofiler.model.ProfilingGroupDescription(
        agentOrchestrationConfig.map(value => value.asEditable),
        arn.map(value => value),
        computePlatform.map(value => value),
        createdAt.map(value => value),
        name.map(value => value),
        profilingStatus.map(value => value.asEditable),
        tags.map(value => value),
        updatedAt.map(value => value)
      )
    def agentOrchestrationConfig: Optional[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ]
    def arn: Optional[ProfilingGroupArn]
    def computePlatform
        : Optional[zio.aws.codeguruprofiler.model.ComputePlatform]
    def createdAt: Optional[Timestamp]
    def name: Optional[ProfilingGroupName]
    def profilingStatus
        : Optional[zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly]
    def tags: Optional[Map[String, String]]
    def updatedAt: Optional[Timestamp]
    def getAgentOrchestrationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "agentOrchestrationConfig",
      agentOrchestrationConfig
    )
    def getArn: ZIO[Any, AwsError, ProfilingGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getName: ZIO[Any, AwsError, ProfilingGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getProfilingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly
    ] = AwsError.unwrapOptionField("profilingStatus", profilingStatus)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
  ) extends zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly {
    override val agentOrchestrationConfig: Optional[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.agentOrchestrationConfig())
      .map(value =>
        zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.wrap(value)
      )
    override val arn: Optional[ProfilingGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.ProfilingGroupArn(value)
      )
    override val computePlatform
        : Optional[zio.aws.codeguruprofiler.model.ComputePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computePlatform())
        .map(value =>
          zio.aws.codeguruprofiler.model.ComputePlatform.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val name: Optional[ProfilingGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName(value)
      )
    override val profilingStatus
        : Optional[zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profilingStatus())
        .map(value =>
          zio.aws.codeguruprofiler.model.ProfilingStatus.wrap(value)
        )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription
  ): zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly =
    new Wrapper(impl)
}
