package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupArn
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ProfilingGroupArn,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest
      .builder()
      .resourceArn(ProfilingGroupArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.UntagResourceRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.UntagResourceRequest =
      zio.aws.codeguruprofiler.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ProfilingGroupArn
    def tagKeys: List[String]
    def getResourceArn: ZIO[Any, Nothing, ProfilingGroupArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest
  ) extends zio.aws.codeguruprofiler.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ProfilingGroupArn =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupArn(impl.resourceArn())
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest
  ): zio.aws.codeguruprofiler.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
