package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters._
sealed trait MetadataField {
  def unwrap
      : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField
}
object MetadataField {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.MetadataField
  ): zio.aws.codeguruprofiler.model.MetadataField = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.COMPUTE_PLATFORM =>
      val r = ComputePlatform
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.AGENT_ID =>
      val r = AgentId
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.AWS_REQUEST_ID =>
      val r = AwsRequestId
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.EXECUTION_ENVIRONMENT =>
      val r = ExecutionEnvironment
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_FUNCTION_ARN =>
      val r = LambdaFunctionArn
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_MEMORY_LIMIT_IN_MB =>
      val r = LambdaMemoryLimitInMB
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_REMAINING_TIME_IN_MILLISECONDS =>
      val r = LambdaRemainingTimeInMilliseconds
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS =>
      val r = LambdaTimeGapBetweenInvokesInMilliseconds
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS =>
      val r = LambdaPreviousExecutionTimeInMilliseconds
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.UNKNOWN_TO_SDK_VERSION
  }
  case object ComputePlatform
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.COMPUTE_PLATFORM
  }
  case object AgentId extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.AGENT_ID
  }
  case object AwsRequestId
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.AWS_REQUEST_ID
  }
  case object ExecutionEnvironment
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.EXECUTION_ENVIRONMENT
  }
  case object LambdaFunctionArn
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_FUNCTION_ARN
  }
  case object LambdaMemoryLimitInMB
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_MEMORY_LIMIT_IN_MB
  }
  case object LambdaRemainingTimeInMilliseconds
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_REMAINING_TIME_IN_MILLISECONDS
  }
  case object LambdaTimeGapBetweenInvokesInMilliseconds
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS
  }
  case object LambdaPreviousExecutionTimeInMilliseconds
      extends zio.aws.codeguruprofiler.model.MetadataField {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetadataField =
      software.amazon.awssdk.services.codeguruprofiler.model.MetadataField.LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS
  }
}
