package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{PaginationToken, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProfilingGroupsRequest(
    includeDescription: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest = {
    import ListProfilingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
      .builder()
      .optionallyWith(
        includeDescription.map(value => value: java.lang.Boolean)
      )(_.includeDescription)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest
      .wrap(buildAwsValue())
}
object ListProfilingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest =
      zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest(
        includeDescription.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def includeDescription: Optional[Boolean]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getIncludeDescription: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDescription", includeDescription)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
  ) extends zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest.ReadOnly {
    override val includeDescription: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeDescription())
      .map(value => value: Boolean)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codeguruprofiler.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
  ): zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
