package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  Locale,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetRecommendationsRequest(
    endTime: Timestamp,
    locale: Optional[Locale] = Optional.Absent,
    profilingGroupName: ProfilingGroupName,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest = {
    import GetRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.GetRecommendationsRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.GetRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.GetRecommendationsRequest =
      zio.aws.codeguruprofiler.model.GetRecommendationsRequest(
        endTime,
        locale.map(value => value),
        profilingGroupName,
        startTime
      )
    def endTime: Timestamp
    def locale: Optional[Locale]
    def profilingGroupName: ProfilingGroupName
    def startTime: Timestamp
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest
  ) extends zio.aws.codeguruprofiler.model.GetRecommendationsRequest.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.endTime())
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Locale(value))
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val startTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest
  ): zio.aws.codeguruprofiler.model.GetRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
