package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupArn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ProfilingGroupArn,
    tags: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest
      .builder()
      .resourceArn(ProfilingGroupArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.TagResourceRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.TagResourceRequest =
      zio.aws.codeguruprofiler.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ProfilingGroupArn
    def tags: Map[String, String]
    def getResourceArn: ZIO[Any, Nothing, ProfilingGroupArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[String, String]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest
  ) extends zio.aws.codeguruprofiler.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ProfilingGroupArn =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupArn(impl.resourceArn())
    override val tags: Map[String, String] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest
  ): zio.aws.codeguruprofiler.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
